// ==================================================================
// cAdmin (Console Administration)
// By: Shayk-N'-Bake
// Instruction / Credits: readme.txt (with distribution of files)
// ==================================================================

//-----------------------------------
//
// Tribes startup
//
//-----------------------------------

// Note: This is not the default console.cs distributed with Tribes. If you don't trust me/my work and don't know beans
// about Tribes coding to skim through it and check for yourself, then feel free to not trust it and not use it. I'd
// love to see everyone who can use this script use it, for it would finally be something I put a little thought into
// that didn't go to waste, on top of the fact that it still can function just as the regular console.cs if you don't
// care to use any of the functionality it was altered to allow. I would be glad to offer any help or answers to anyone
// who might not understand this script completely. Simply post in the forums at http://tribes.zapto.org/phpBB/ and
// you'll get an answer from me there. I would appreciate it if anyone who may make their own changes to this script
// would contact me and send me copies of it so I can see it for myself and consider incorporating such changes into it
// officially. Any such contributors will naturally be credited.
// -- Shayk-N'-Bake

// targetLine: creating this variable with the proper values can overrule's any settings sent to the game upon startup.
// Exception: This line has no effect on server if it is set in the cAdmin.s.modSetting.cs file, executed below.
//$targetLine = "+exec <configFile>.cs -mod <modFolder> -dedicated";

$ConsoleWorld::DefaultSearchPath = "config";
// Loads up $targetLine var if one is set in file. Changeable via cAdmin actions, or manually *duh*.
// Naturally overwrites the $targetLine above if it is set, unless you place the line below it.
exec("cAdmin.s.modSetting.cs");

// -
// -
// -
// -

// ======================================================================
// CRUCIAL TRIBES FUNCTIONS: (EDIT NO FURTHER!) -- Shayk-N'-Bake
// ======================================================================

// test if this is a dedicated server
$dedicated = false;

$numExecFiles = 0;

$modList = "base"; // Some reason this isn't happening with my target line changes... So putting this here. -- Shayk-N'-Bake

function isDefined(%var)
{
	if(%var != -1 && %var != false && %var != "")
		return true;
	else
		return false;
}

function getNumWords(%var)
{
	if(isDefined(%var))
	{
		%i = 0;
		while(isDefined(getWord(%var, %i)))
			%i++;
		%words = %i;
		return %words;
	}
	else
		return "";
}

function targetLine::BuildArray()
{
	%targetLine = $targetLine;
	%wordCount = (getNumWords(%targetLine) - 1);
	%i = 0;
	while(isDefined((%word = getWord(%targetLine, %i))))
	{
		$targetLineWord[%i] = %word;
		%i++;
	}
}

function targetLine::Execute()
{
	targetLine::BuildArray();
		
	%i = 0;
	while(isDefined((%targetLineWord = $targetLineWord[%i])))
	{
	 	if($targetLineWord[%i] == "-mod")
	 	{
	  	%mod = $targetLineWord[%i + 1];
	  	$modList = %mod @ " " @ $modList;
			$modCount++;
	  }
	  else if($targetLineWord[%i] == "-dedicated")
	  {
	   	$dedicated = true;
	   	%mission = $targetLineWord[%i + 1];
	   	if(%mission != "")
	   	{
	     	$HostMission = %mission;
	   	}
	  }
	  else if($targetLineWord[%i] == "+exec")
	  {
	   	$execFile[$numExecFiles] = $targetLineWord[%i+1];
	  	$rememberThisFile = $execFile[$numExecFiles];
	  	$numExecFiles++;
	  }
	  else if($targetLineWord[%i] == "+connect")
	  {
	   	$connectAddress = $targetLineWord[%i+1];
	  }
	  else if($targetLineWord[%i] == "+password")
	  {
	   	$Server::JoinPassword = $targetLineWord[%i+1];
	   	$Server::Password = $targetLineWord[%i+1];
	  }
	  else if($targetLineWord[%i] == "+record")
	  {
	   	setupRecorderFile();
	  }
	  else if($targetLineWord[%i] == "-host")
	  {
	   	$HostMission = $targetLineWord[%i+1];
	   	$HostingGame = true;
	  }
	  else if($targetLineWord[%i] == "+maxplayers")
	  {
	   	$HostPlayerCount = $targetLineWord[%i+1];
	  }
	  else if($targetLineWord[%i] == "-edit")
	  {
	  	$EditingMission = true;
	  	$EditMission = $targetLineWord[%i+1];
	  }
	  %i++;
	}
}

function targetLine::Abort()
{
	for(%i = 1; $cargv[%i] != ""; %i++)
	{
	   if($cargv[%i] == "-mod")
	   {
	      %mod = $cargv[%i + 1];
	      %i++;
	      $modList = %mod @ " " @ $modList;
			$modCount++;
	   }
	   else if($cargv[%i] == "-dedicated")
	   {
	      $dedicated = true;
	      %mission = $cargv[%i + 1];
	      if(%mission != "")
	      {
	         $HostMission = %mission;
	         %i++;
	      }
	   }
	   else if($cargv[%i] == "+exec")
	   {
	      $execFile[$numExecFiles] = $cargv[%i+1];
	      %i++;
	      $numExecFiles++;
	   }
	   else if($cargv[%i] == "+connect")
	   {
	      $connectAddress = $cargv[%i+1];
	      %i++;
	   }
	   else if($cargv[%i] == "+password")
	   {
	      $Server::JoinPassword = $cargv[%i+1];
	      $Server::Password = $cargv[%i+1];
	      %i++;
	   }
	   else if($cargv[%i] == "+record")
	   {
	      setupRecorderFile();
	   }
	   else if($cargv[%i] == "-host")
	   {
	      $HostMission = $cargv[%i+1];
	      $HostingGame = true;
	      %i++;
	   }
	   else if($cargv[%i] == "+maxplayers")
	   {
	      $HostPlayerCount = $cargv[%i+1];
	      %i++;
	   }
	   else if($cargv[%i] == "-edit")
	   {
	      $EditingMission = true;
	      $EditMission = $cargv[%i+1];
	      %i++;
	   }
	}
}

if(isDefined($targetLine))
{ targetLine::Execute(); }
else
{ targetLine::Abort(); }

$WinConsoleEnabled = $dedicated;
$Console::logBufferEnabled = !$dedicated; // turn off window scroll back
$Console::Prompt = "% ";

if($dedicated)
{
   newServer();
   focusServer();
}
else
{
   newClient();
   focusClient();
   $Console::LastLineTimeout = 0;
}

function EvalSearchPath()
{
   // search path always contains the config directory
   %searchPath = "config";
   if($modList == "")
      $modList = "base";
   else
   {
      for(%i = 0; (%word = getWord($modList, %i)) != -1; %i++)
         if(%word == "base")
            break;
      if(%word == -1)
         $modList = $modList @ " base";
   }
   for(%i = 0; (%word = getWord($modList, %i)) != -1; %i++)
   {
      %addPath = %word @ ";" @ %word @ "\\missions;" @ %word @ 
         "\\fonts;" @ %word @ "\\skins;" @ %word @ "\\voices;" @ %word @ "\\scripts";
      %searchPath = %searchPath @ ";" @ %addPath;
   }
   %searchPath = %searchPath @ ";recordings;temp";
   echo(%searchPath);

   $ConsoleWorld::DefaultSearchPath = %searchPath;

   // clear out the volumes:
   for(%i = 0; isObject(%vol = "VoiceVolume" @ %i); %i++)
      deleteObject(%vol);
   for(%i = 0; isObject(%vol = "SkinVolume" @ %i); %i++)
      deleteObject(%vol);

   // load all the volumes:
   %file = File::findFirst("voices\\*.vol");
   for(%i = 0; %file != ""; %file = File::findNext("voices\\*.vol"))
      if(newObject("VoiceVolume" @ %i, SimVolume, %file))
         %i++;

   %file = File::findFirst("skins\\*.vol");
   for(%i = 0; %file != ""; %file = File::findNext("skins\\*.vol"))
      if(newObject("SkinVolume" @ %i, SimVolume, %file))
         %i++;
}

function LoadModVolumes()
{
	// Load mod volumes in the order they were declared
   for(%i = $modCount - 1; %i >= 0; %i--)
   {
		%word = getWord($modList, %i);
		%vol = %word @ ".vol";
		if (isFile(%word @ "\\" @ %vol))
			newObject(%word @ "Volume", SimVolume, %vol);
   }
}

function ExecModScripts()
{
	// Exec mod scripts in the order they were declared
   for(%i = $modCount - 1; %i >= 0; %i--)
		exec(getWord($modList, %i) @ ".cs");
}

//
EvalSearchPath();
LoadModVolumes();
newObject(FontsVolume, SimVolume, "fonts.vol");
newObject(ScriptsVolume, SimVolume, "scripts.vol");
newObject(GuiVolume, SimVolume, "gui.vol");
newObject(EditVolume, SimVolume, "edit.vol");
newObject(EditorVolume, SimVolume, "editor.vol");
newObject(DarkstarVolume, SimVolume, "darkstar.vol");
newObject(InterfaceVolume, SimVolume, "interface.vol");
newObject(ShellVolume, SimVolume, "shell.vol");
newObject(ShellCommonVolume, SimVolume, "shellcommon.vol");
newObject(EntitiesVolume, SimVolume, "entities.vol");

$Console::GFXFont = "interface.pft";

////
// Default volumes and tags
//

exec("darkstar.strings.cs");
exec("editor.strings.cs");
exec("commonEditor.strings.cs");
exec("esf.strings.cs");
exec("fear.strings.cs");
exec("help.strings.cs");
exec("sfx.strings.cs");
exec("banlist.cs");
exec("missionList.cs");
exec("gui.cs");
exec("sae.cs");
exec("client.cs");
exec("server.cs");
exec("tsDefaultMatProps.cs");
exec("game.cs");
exec("GenericTriggers.cs");
exec("chatmenu.cs");
exec("menu.cs");
exec("observer.cs");
exec("PlayerSetup.cs");
exec("players.cs");

newObject("", IRCClient);
exec("IRCClient.cs");
exec("IRCServers.cs");

exec("Options.cs");
exec("commander.cs");

ExecModScripts();

//
// Default keys
//
bind(keyboard, make, control, o, to, "messageCanvasDevice(MainWindow, outline);");
bind(keyboard, make, sysreq, to, "screenShot(MainWindow);");
bind(keyboard, make, control, "-", to, "prevRes(MainWindow);");
bind(keyboard, make, control, "+",  to, "nextRes(MainWindow);");

// Load prefs and execute any autoexec commands...
exec("clientDefaults.cs");
exec("serverDefaults.cs");
exec("clientPrefs.cs");
exec("serverPrefs.cs");
exec("config.cs");
exec("badwords.cs");
exec("autoexec.cs");

for(%i = 0; %i < $numExecFiles; %i++)
   exec($execFile[%i]);

if($dedicated)
{
	if ($modCount && $MODInfo == "")
		$MODInfo = "This server is running the following mods: " @ $modList;

   if($HostPlayerCount > 0)
      $Server::MaxPlayers = $HostPlayerCount;
   createServer($HostMission, True);
	translateMasters();
	echo("Dedicated Server Initialized");
}
else
{
   newObject(ConsoleScheduler, SimConsoleScheduler);

   // Create the main window with a gui in it
   newObject(MainWindow, SimGui::Canvas, "Tribes", 640, 480, True, "512 384", "1024 768");

   exec("sound.cs");
   inputActivate(keyboard0);
   inputActivate(mouse0);

   if($pref::noIpx)
      newObject(clientDelegate, FearCSDelegate, false, "IP", 0, "LOOPBACK", 0);
   else
      newObject(clientDelegate, FearCSDelegate, false, "IP", 0, "IPX", 0, "LOOPBACK", 0);
   if(!$pref::lanOnly)
   	translateMasters();

   // Action map for flying cameras
   exec("move.cs");
   move();

   // Play the intro smacker file
   setCursor(MainWindow, "Cur_Empty.bmp");
   cursorOn(MainWindow);
   GuiLoadContentCtrl(MainWindow, "gui\\empty.gui");

   //all video initialization is now done in Options.cs
   OptionsVideo::validate();
   OptionsVideo::apply();

   if ($pref::cdMusic == "")
   	$pref::cdMusic = True;
   if ($pref::cdVolume == "")
   	$pref::cdVolume = 0.5;
   if ($pref::userCDOverride == "")
   	$pref::userCDOverride = False;
   if ($pref::cdMusic || $pref::userCDOverrride)
   {
   	newRedBook (CD, MainWindow);
   	rbSetVolume (CD, 1 - $pref::cdVolume);
   }
   if($HostingGame)
   {
      setCursor(MainWindow, "Cur_Arrow.bmp");
      cursorOn(MainWindow);
      if($HostPlayerCount > 0)
         $Server::MaxPlayers = $HostPlayerCount;
      createServer($HostMission, false);
      $quitOnDisconnect = true;
   }
   else if($connectAddress != "")
   {
      $Server::Address = $connectAddress;
      IRCLogin::AutoConnect();
      setCursor(MainWindow, "Cur_Arrow.bmp");
      cursorOn(MainWindow);
      JoinGame();
      $quitOnDisconnect = true;
   }
   else if($EditingMission)
   {
      setCursor(MainWindow, "Cur_Arrow.bmp");
      cursorOn(MainWindow);
      if($HostPlayerCount > 0)
         $Server::MaxPlayers = $HostPlayerCount;
      exec(editor);
      
      // check if creating or not
      %missionFile = "missions\\" @ $EditMission @ ".mis";
      if(File::FindFirst(%missionFile) == "")
      {
         GuiLoadContentCtrl(MainWindow, "gui\\mainmenu.gui");
         $NewMissionName = $EditMission;
         exec(newmission);
      }
      else
         createServer($EditMission, false);
      $quitOnDisconnect = false;
   }
   else
   {
      //translate all master server addressess - this function will eventually call startTheGame()
      if($pref::quickstart)
      {
         GuiLoadContentCtrl(MainWindow, "gui\\mainmenu.gui");
         Quickstart();
   	   translateMasters();
      }
      else
      {
         if (!$pref::skipIntro)
            GuiLoadContentCtrl(MainWindow, "gui\\intro.gui");
         else
   	      startMainMenuScreen();
      }

      //autologin to the irc client
      IRCLogin::AutoConnect();
   }
	echo("Client Initialized");
}

// This executes the cAdmin file and any other files I may add to it's functionality at a later time.
exec("execShayk.cs");